/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config.json;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.codec.CodecUtil;

@Deprecated
public record BiomeDictionaryConfig(Map<class_5321<class_1959>, List<String>> biomeDictionary) {
    public static final BiomeDictionaryConfig DEFAULT = new BiomeDictionaryConfig((Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> {
        map.put(BYGBiomes.ALLIUM_FIELDS, List.of("PLAINS", "RARE", "LUSH", "OVERWORLD"));
        map.put(BYGBiomes.AMARANTH_FIELDS, List.of("PLAINS", "RARE", "LUSH", "OVERWORLD"));
        map.put(BYGBiomes.FORGOTTEN_FOREST, List.of("FOREST", "MAGICAL", "RARE", "OVERWORLD"));
        map.put(BYGBiomes.ARAUCARIA_SAVANNA, List.of("FOREST", "OVERWORLD"));
        map.put(BYGBiomes.ASPEN_FOREST, List.of("FOREST", "OVERWORLD"));
        map.put(BYGBiomes.AUTUMNAL_VALLEY, List.of("PLAINS", "DRY", "OVERWORLD"));
        map.put(BYGBiomes.BAOBAB_SAVANNA, List.of("SAVANNA", "SPARSE", "DRY", "OVERWORLD"));
        map.put(BYGBiomes.BAYOU, List.of("SWAMP", "FOREST", "WET", "OVERWORLD"));
        map.put(BYGBiomes.FROSTED_TAIGA, List.of("FOREST", "SNOWY", "CONIFEROUS", "OVERWORLD"));
        map.put(BYGBiomes.CANADIAN_SHIELD, List.of("MOUNTAIN", "CONIFEROUS", "COLD", "OVERWORLD"));
        map.put(BYGBiomes.BOREALIS_GROVE, List.of("FOREST", "OVERWORLD"));
        map.put(BYGBiomes.CHERRY_BLOSSOM_FOREST, List.of("FOREST", "OVERWORLD"));
        map.put(BYGBiomes.CIKA_WOODS, List.of("FOREST", "COLD", "CONIFEROUS", "OVERWORLD"));
        map.put(BYGBiomes.CONIFEROUS_FOREST, List.of("FOREST", "COLD", "CONIFEROUS", "OVERWORLD"));
        map.put(BYGBiomes.CRAG_GARDENS, List.of("JUNGLE", "WET", "PLATEAU", "RARE", "MAGICAL", "OVERWORLD"));
        map.put(BYGBiomes.CYPRESS_SWAMPLANDS, List.of("SWAMP", "OVERWORLD"));
        map.put(BYGBiomes.LUSH_STACKS, List.of("OCEAN", "WASTELAND", "SPOOKY", "OVERWORLD"));
        map.put(BYGBiomes.DACITE_RIDGES, List.of("MOUNTAIN", "COLD", "CONIFEROUS", "OVERWORLD"));
        map.put(BYGBiomes.WINDSWEPT_DUNES, List.of("DRY", "HOT", "SANDY", "OVERWORLD"));
        map.put(BYGBiomes.WINDSWEPT_DESERT, List.of("DRY", "HOT", "SANDY", "OVERWORLD"));
        map.put(BYGBiomes.EBONY_WOODS, List.of("FOREST", "DENSE", "OVERWORLD"));
        map.put(BYGBiomes.FORGOTTEN_FOREST, List.of("FOREST", "RARE", "MAGICAL", "OVERWORLD"));
        map.put(BYGBiomes.GROVE, List.of("PLAINS", "LUSH", "OVERWORLD"));
        map.put(BYGBiomes.GUIANA_SHIELD, List.of("JUNGLE", "HOT", "DENSE", "FOREST", "MOUNTAIN", "OVERWORLD"));
        map.put(BYGBiomes.JACARANDA_FOREST, List.of("FOREST", "OVERWORLD"));
        map.put(BYGBiomes.MAPLE_TAIGA, List.of("FOREST", "COLD", "OVERWORLD"));
        map.put(BYGBiomes.COCONINO_MEADOW, List.of("PLAINS", "LUSH", "COLD", "OVERWORLD"));
        map.put(BYGBiomes.MOJAVE_DESERT, List.of("DRY", "HOT", "SANDY", "OVERWORLD"));
        map.put(BYGBiomes.ORCHARD, List.of("PLAINS", "LUSH", "FOREST", "OVERWORLD"));
        map.put(BYGBiomes.PRAIRIE, List.of("PLAINS", "DRY", "OVERWORLD"));
        map.put(BYGBiomes.RED_OAK_FOREST, List.of("FOREST", "OVERWORLD"));
        map.put(BYGBiomes.RED_ROCK_VALLEY, List.of("DRY", "HOT", "MOUNTAIN", "OVERWORLD"));
        map.put(BYGBiomes.REDWOOD_THICKET, List.of("FOREST", "DENSE", "RARE", "OVERWORLD"));
        map.put(BYGBiomes.ROSE_FIELDS, List.of("OVERWORLD", "PLAINS", "RARE", "LUSH"));
        map.put(BYGBiomes.AUTUMNAL_FOREST, List.of("FOREST", "COLD", "OVERWORLD"));
        map.put(BYGBiomes.AUTUMNAL_TAIGA, List.of("FOREST", "COLD", "CONIFEROUS", "OVERWORLD"));
        map.put(BYGBiomes.SHATTERED_GLACIER, List.of("SNOWY", "OVERWORLD", "RARE"));
        map.put(BYGBiomes.FIRECRACKER_SHRUBLAND, List.of("PLAINS", "DRY", "SPARSE", "OVERWORLD"));
        map.put(BYGBiomes.SIERRA_BADLANDS, List.of("DRY", "HOT", "PLAINS", "OVERWORLD"));
        map.put(BYGBiomes.SKYRIS_VALE, List.of("MAGICAL", "FOREST", "LUSH", "RARE", "OVERWORLD"));
        map.put(BYGBiomes.FROSTED_CONIFEROUS_FOREST, List.of("FOREST", "SNOWY", "CONIFEROUS", "OVERWORLD"));
        map.put(BYGBiomes.FRAGMENT_FOREST, List.of("OVERWORLD", "DENSE", "PLATEAU"));
        map.put(BYGBiomes.BLACK_FOREST, List.of("OVERWORLD", "DENSE", "PLATEAU"));
        map.put(BYGBiomes.TWILIGHT_MEADOW, List.of("COLD", "WASTELAND", "MAGICAL", "OVERWORLD"));
        map.put(BYGBiomes.WEEPING_WITCH_FOREST, List.of("FOREST", "COLD", "MAGICAL", "RARE", "SPOOKY", "OVERWORLD"));
        map.put(BYGBiomes.TEMPERATE_RAINFOREST, List.of("FOREST", "DENSE", "MAGICAL", "OVERWORLD"));
        map.put(BYGBiomes.ZELKOVA_FOREST, List.of("CONIFEROUS", "COLD", "FOREST", "OVERWORLD"));
    }));
    public static BiomeDictionaryConfig INSTANCE = null;
    public static final Codec<BiomeDictionaryConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap(CodecUtil.BIOME_CODEC, (Codec)Codec.STRING.listOf()).fieldOf("dictionary").forGetter(overworldBiomeConfig -> overworldBiomeConfig.biomeDictionary)).apply((Applicative)builder, BiomeDictionaryConfig::new));

    public static BiomeDictionaryConfig getConfig() {
        return BiomeDictionaryConfig.getConfig(false, false);
    }

    public static BiomeDictionaryConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = BiomeDictionaryConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    private static BiomeDictionaryConfig readConfig(boolean recreate) {
        Path path = ModPlatform.INSTANCE.configPath().resolve("byg-biome-dictionary.json");
        if (!path.toFile().exists() || recreate) {
            JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)DEFAULT).result().get();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BYG.LOGGER.error(e.toString());
            }
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return (BiomeDictionaryConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(path.toFile()))).result().orElseThrow(RuntimeException::new)).getFirst();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return DEFAULT;
        }
    }
}

